package w83b.w83bOperacionesPaso.w83bImpugnaciones;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFRegionUtil;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bClsEstilosExcel;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bFichaImpugnacionesAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaImpugnacion.xls";
		InputStream inputStream = W83bFichaImpugnacionesAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
		W83bImpugnacionBean impugnacion=(W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBeanTemp");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
         
        HSSFHeader header = sheet.getHeader();
        header.setRight(HSSFHeader.fontSize((short)6)+" "+W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        HSSFFooter footer = sheet.getFooter();
        footer.setCenter(HSSFFooter.fontSize((short)6) +((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(HSSFFooter.fontSize((short)6) + Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{HSSFFooter.page()}));

        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);

        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
 	   
		StringBuffer  tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
		cell.setCellValue(tituloImagenEu.toString());
	    cell = row.getCell((short)6); 
	    cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs"); 
       
        row = sheet.getRow((short)5); 
        cell = row.getCell((short)4);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
              
        String aux="";
        
        int inicio=7;
        //Titulo
        row = sheet.createRow((short)inicio); 
        cell = row.createCell((short)0); 
        HSSFCellStyle estilo=W83bClsEstilosExcel.estiloNegritaSubrayado(wb);
        estilo.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        cell.setCellStyle(estilo);
         cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.labels.ficha",idioma));
         HSSFCellStyle estiloAjust=W83bClsEstilosExcel.estiloCadenaAutoAjust(wb);
         
         int inicioDatos=inicio+2;
         int j=inicioDatos;
        //Datos del impugnacion
        row = sheet.createRow((short)j); 
        cell = row.createCell((short)3); 
        cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));

        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.labels.datosbasicos",idioma));
        
        sheet.addMergedRegion(new Region(j+1,Short.parseShort("3"),j+1,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+1); 
        cell = row.createCell((short)3); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",idioma)
        		+":  "+impugnacion.getTerritorioImpugnacion()+"/"+impugnacion.getAnyoImpugnacion()+"/"+impugnacion.getNumImpugnacion());
        cell.setCellStyle(estiloAjust);
       
        
        sheet.addMergedRegion(new Region(j+1,Short.parseShort("5"),j+1,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+1); 
        cell = row.createCell((short)5); 
        String dniArbitro = impugnacion.getArbitro();
        if(StringUtils.isEmpty(dniArbitro)){
        	dniArbitro = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.dni",idioma)+" "+
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.arbitro",idioma)
        		+":  "+dniArbitro);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+2,Short.parseShort("3"),j+2,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+2); 
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(impugnacion.getAnyoActa()))
        		{
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nActa",idioma)
            		+":  "+impugnacion.getTerritorioImpugnacion()+"/"+impugnacion.getAnyoActa()+"/"+impugnacion.getNumActa());
            
        		}else{
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nActa",idioma)
        	        		+":  ");
        	        
        		}
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+2,Short.parseShort("5"),j+2,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+2); 
        cell = row.createCell((short)5); 
        String nombreArbitro = impugnacion.getNombrearbitro();
        if(StringUtils.isEmpty(nombreArbitro)){
        	nombreArbitro = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nombre",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(nombreArbitro));
        int tamanyoTexto=cell.getStringCellValue().length();
        
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        if(tamanyoTexto>33)
        {
        	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/32)+1)));
        }
        sheet.addMergedRegion(new Region(j+3,Short.parseShort("3"),j+3,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+3); 
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(impugnacion.getAnyoPreaviso()))
		{
			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nPreaviso",idioma)
    		+":  "+impugnacion.getTerritorioImpugnacion()+"/"+impugnacion.getAnyoPreaviso()+"/"+impugnacion.getNumPreaviso());
    
		}else{
			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nPreaviso",idioma)
	        		+":  ");
	        
		}
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+3,Short.parseShort("5"),j+3,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+3); 
        cell = row.createCell((short)5); 
        String fechaEnvioArbitro = impugnacion.getFechaEnvioArbitro();
        if(StringUtils.isEmpty(fechaEnvioArbitro)){
        	fechaEnvioArbitro = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaEnvioArbitro",idioma)
        		+":  "+fechaEnvioArbitro);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        
//        sheet.addMergedRegion(new Region(j+4,Short.parseShort("3"),j+4,Short.parseShort("7")));//NOPMD
//        row = sheet.createRow((short)j+4); 
//        cell = row.createCell((short)3); 
//        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.asunto",idioma)
//        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getAsunto()));
//      
//       cell.setCellStyle(estiloAjust);
//       tamanyoTexto=cell.getStringCellValue().length();
//        if(tamanyoTexto>55)
//        {
//        	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/54)+1)));
//        }
        
        /**/
        sheet.addMergedRegion(new Region(j+4,Short.parseShort("3"),j+4,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+4); 
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(impugnacion.getNum_registro()))
        {
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.numregistroes",idioma)
        			+":  "+impugnacion.getNum_registro());
        	
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.numregistroes",idioma)
        			+":  ");
        	
        }
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+4,Short.parseShort("5"),j+4,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+4); 
        cell = row.createCell((short)5); 
        String fechaRegistro = impugnacion.getFecha_registro();
        if(StringUtils.isEmpty(fechaRegistro)){
        	fechaRegistro = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fecharegistroes",idioma)
        		+":  "+fechaRegistro);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        /**/
        
        sheet.addMergedRegion(new Region(j+5,Short.parseShort("3"),j+5,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+5); 
        cell = row.createCell((short)3); 
        String asunto = impugnacion.getAsunto();
        if(StringUtils.isEmpty(asunto)){
        	asunto = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.asunto",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(asunto));
        
        cell.setCellStyle(estiloAjust);
        tamanyoTexto=cell.getStringCellValue().length();
        if(tamanyoTexto>55)
        {
        	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/54)+1)));
        }
        
        sheet.addMergedRegion(new Region(j+6,Short.parseShort("3"),j+6,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+6); 
        cell = row.createCell((short)3); 
        String decision = impugnacion.getDecision();
        if(StringUtils.isEmpty(decision)){
        	decision = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.decision",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(decision));
        cell.setCellStyle(estiloAjust);
        tamanyoTexto=cell.getStringCellValue().length();
        if(tamanyoTexto>55)
        {
        	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/54)+1)));
        }
        sheet.addMergedRegion(new Region(j+7,Short.parseShort("3"),j+7,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+7); 
        cell = row.createCell((short)3); 
        String fechaImp = impugnacion.getFechaImpugnacion();
        if(StringUtils.isEmpty(fechaImp)){
        	fechaImp = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaImpugnacion",idioma)
        		+":  "+fechaImp);
        
        sheet.addMergedRegion(new Region(j+7,Short.parseShort("5"),j+7,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+7); 
        cell = row.createCell((short)5); 
        String fechaDes = impugnacion.getFechaDesestimiento();
        if(StringUtils.isEmpty(fechaDes)){
        	fechaDes = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaDesestimiento",idioma)
        		+":  "+fechaDes);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
       
        sheet.addMergedRegion(new Region(j+8,Short.parseShort("3"),j+8,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+8); 
        cell = row.createCell((short)3); 
        String fechaSent = impugnacion.getFechaSentencia();
        if(StringUtils.isEmpty(fechaSent)){
        	fechaSent = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fSentencia",idioma)
        		+":  "+fechaSent);
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+8,Short.parseShort("5"),j+8,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+8); 
        cell = row.createCell((short)5); 
        String fechaEnvioJ = impugnacion.getFechaEnvioJuzgado();
        if(StringUtils.isEmpty(fechaEnvioJ)){
        	fechaEnvioJ = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fEnvioJuzgado",idioma)
        		+":  "+fechaEnvioJ);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+9,Short.parseShort("3"),j+9,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+9); 
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(impugnacion.getAnyoLaudo()))
		{
        	   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nLaudo",idioma)
               		+":  "+impugnacion.getTerritorioImpugnacion()+"/"+impugnacion.getAnyoLaudo()+"/"+impugnacion.getNumLaudo());
               
              
		}else{
				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nLaudo",idioma)
               		+":  ");
	        
		}
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(j+9,Short.parseShort("5"),j+9,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)j+9); 
        cell = row.createCell((short)5); 
        String fechaLaudo = impugnacion.getFechaLaudo();
        if(StringUtils.isEmpty(fechaLaudo)){
        	fechaLaudo = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudo",idioma)
        		+":  "+fechaLaudo);
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        
        
        sheet.addMergedRegion(new Region(j+10,Short.parseShort("3"),j+10,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)j+10); 
        cell = row.createCell((short)3); 
        aux=impugnacion.getDescresultado();
        if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
        { aux=impugnacion.getDeseresultado();
        	
        }
        if(StringUtils.isEmpty(aux)){
        	aux = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux));
        cell.setCellStyle(estiloAjust);
        
        //fin Datos del impugnacion
        int findatos=j+11;
        Region region = new Region(inicioDatos,(short)2,findatos,(short)8);
        HSSFRegionUtil.setBorderBottom((short) 1, region, sheet, wb);
        HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
        HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderRight((short)1, region, sheet, wb);
        HSSFRegionUtil.setRightBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderLeft((short)1, region, sheet, wb);
        HSSFRegionUtil.setLeftBorderColor((short)0, region, sheet, wb); 
        int inicioCentro=j+12+1;
        int z=inicioCentro;
        //Datos del Centro
        row = sheet.createRow((short)z); 
        cell = row.createCell((short)3); 
        cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));

        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.datosCentroTrabajo",idioma));
        
        //fin Datos del Centro
        sheet.addMergedRegion(new Region(z+1,Short.parseShort("3"),z+1,Short.parseShort("4")));//NOPMD
        
        row = sheet.createRow((short)z+1); 
        cell = row.createCell((short)3); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.cif",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getCentroTrabajo().getCifnif()));
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)4); 
        cell.setCellStyle(estiloAjust);
        
        sheet.addMergedRegion(new Region(z+1,Short.parseShort("5"),z+1,Short.parseShort("7")));//NOPMD
        row = sheet.createRow((short)z+1); 
        cell = row.createCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.numCentro",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getCentroTrabajo().getNumCentro()));
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)6); 
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
         cell.setCellStyle(estiloAjust);
       
       

    	
        sheet.addMergedRegion(new Region(z+2,Short.parseShort("3"),z+2,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)z+2); 
	   	cell = row.createCell((short)3); 
	    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.razonSocial",idioma)
	    		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getCentroTrabajo().getRazonSocial()));
	    cell.setCellStyle(estiloAjust);
	    tamanyoTexto=cell.getStringCellValue().length();
        if(tamanyoTexto>55)
        {
        	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/54)+1)));
        }
	    cell = row.createCell((short)4); 
        cell.setCellStyle(estiloAjust);
	
	    sheet.addMergedRegion(new Region(z+3,Short.parseShort("3"),z+3,Short.parseShort("4")));//NOPMD
	    row = sheet.createRow((short)z+3); 
        cell = row.createCell((short)3); 
        aux=impugnacion.getCentroTrabajo().getTerritorio();
        if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
        {aux=impugnacion.getCentroTrabajo().getTerritorio_eusk();
        	
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.provincia",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux));
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)4); 
        cell.setCellStyle(estiloAjust);
        
        
        sheet.addMergedRegion(new Region(z+3,Short.parseShort("5"),z+3,Short.parseShort("7")));//NOPMD
	    row = sheet.createRow((short)z+3); 
        cell = row.createCell((short)5); 
        
        aux=impugnacion.getCentroTrabajo().getMunicipio();
        if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
        {aux=impugnacion.getCentroTrabajo().getMunicipio_eusk();
        	
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.municipio",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux));
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)7); 
        cell.setCellStyle(estiloAjust);
        
        int finCentro=z+4;
        int iImpug=z+6;
        
        region = new Region(inicioCentro,(short)2,finCentro,(short)8);
        HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
        HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
        HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderRight((short)1, region, sheet, wb);
        HSSFRegionUtil.setRightBorderColor((short)0, region, sheet, wb);
        HSSFRegionUtil.setBorderLeft((short)1, region, sheet, wb);
        HSSFRegionUtil.setLeftBorderColor((short)0, region, sheet, wb); 
        
        
        //Datos Impugnante
        row = sheet.createRow((short)iImpug); 
        cell = row.createCell((short)3); 
        cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.impugnante",idioma));
       

        //fin Datos del Centro
        
       
        sheet.addMergedRegion(new Region(iImpug+1,Short.parseShort("3"),iImpug+1,Short.parseShort("4")));//NOPMD
        row = sheet.createRow((short)iImpug+1); 
        cell = row.createCell((short)3); 
        aux=impugnacion.getDesctipoImpugnacion();
        if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
        {
        	aux=impugnacion.getDesetipoImpugnacion();
        	
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.tipoImpugnante",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux));
        cell.setCellStyle(estiloAjust);
        cell = row.createCell((short)4); 
        cell.setCellStyle(estiloAjust);
        //se pintaran los datos de empresa
        int i=iImpug+2;
        if(impugnacion.getTipoImpugnacion().equals("1"))
        {
        	sheet.addMergedRegion(new Region(i+1,Short.parseShort("3"),i+1,Short.parseShort("4")));//NOPMD
        	  row = sheet.createRow((short)i+1); 
              cell = row.createCell((short)3); 
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.dniImpugnante",idioma)+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getDniImpug()));
              cell.setCellStyle(estiloAjust);
              cell = row.createCell((short)4); 
              cell.setCellStyle(estiloAjust);
              
              sheet.addMergedRegion(new Region(i+2,Short.parseShort("3"),i+2,Short.parseShort("4")));//NOPMD
          	row = sheet.createRow((short)i+2); 
              cell = row.createCell((short)3); 
              String nombreImpugnacion = impugnacion.getNombreImpug();
              if(StringUtils.isEmpty(nombreImpugnacion)){
            	  nombreImpugnacion = "";
              }
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nombreApellidos",idioma)+":  "
            		  +W83bUtilidadesExcel.mayusculasCampoExcel(nombreImpugnacion));
              cell.setCellStyle(estiloAjust);
              cell = row.createCell((short)4); 
              cell.setCellStyle(estiloAjust);
              
              sheet.addMergedRegion(new Region(i+3,Short.parseShort("3"),i+3,Short.parseShort("4")));//NOPMD
              row = sheet.createRow((short)i+3); 
              cell = row.createCell((short)3); 
              String dirImpugnante = impugnacion.getDirImpug();
              if(StringUtils.isEmpty(dirImpugnante)){
            	  dirImpugnante = "";
              }
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.direccion",idioma)+":  "
            		  +W83bUtilidadesExcel.mayusculasCampoExcel(dirImpugnante));
              tamanyoTexto=cell.getStringCellValue().length();
              if(tamanyoTexto>55)
              {
              	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/54)+1)));
              }
              cell.setCellStyle(estiloAjust);
              cell = row.createCell((short)4); 
              cell.setCellStyle(estiloAjust);
              
              sheet.addMergedRegion(new Region(i+4,Short.parseShort("3"),i+4,Short.parseShort("4")));//NOPMD
              row = sheet.createRow((short)i+4); 
              cell = row.createCell((short)3); 
              aux=impugnacion.getProvinciaImpugTxtC();
              if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA)){
              		aux=impugnacion.getProvinciaImpugTxtE();
              }
              if(StringUtils.isEmpty(aux)){
            	  aux = "";
              }
              
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.provincia",idioma)+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux)); 
              cell.setCellStyle(estiloAjust);
              cell = row.createCell((short)4); 
              cell.setCellStyle(estiloAjust);
              
              aux=impugnacion.getMunicipioImpugTxtC();
              if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA)){
              		aux=impugnacion.getMunicipioImpugTxtE();
              }
              if(StringUtils.isEmpty(aux)){
            	  aux = "";
              }
              sheet.addMergedRegion(new Region(i+5,Short.parseShort("3"),i+5,Short.parseShort("4")));//NOPMD
              row = sheet.createRow((short)i+5); 
              cell = row.createCell((short)3); 
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.municipio",idioma)+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(aux));
              cell.setCellStyle(estiloAjust);
             i=i+6;
              
        }else if(impugnacion.getTipoImpugnacion().equals("2"))
        {
        	   sheet.addMergedRegion(new Region(i+1,Short.parseShort("3"),i+1,Short.parseShort("6")));//NOPMD
               
        	  row = sheet.createRow((short)i+1); 
              cell = row.createCell((short)3); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.sindicatos",idioma));
              cell = row.createCell((short)4); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell = row.createCell((short)5); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell = row.createCell((short)6); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
             
              i=i+2;
              
              String[] desc=impugnacion.getSindicatos_desc().split("\\?");
              String[] dese=impugnacion.getSindicatos_dese().split("\\?");
              String[] datos;
              
              if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
              	datos=dese;
              else
             	 datos=desc;
              
        	for(int w=0;w<datos.length;w++){
        		if(datos[w].split("@").length>0){
	        		 String  cods=datos[w].split("@")[1];
	        		 String descripciones=datos[w].split("@")[0];
	            	             	 
	        		 sheet.addMergedRegion(new Region(i,Short.parseShort("3"),i,Short.parseShort("7")));//NOPMD
	        		        	
	            	 row = sheet.createRow((short)i); 
	                 cell = row.createCell((short)3); 
	            	 cell.setCellValue( cods+" - "+W83bUtilidadesExcel.mayusculasCampoExcel(descripciones));
	            	 tamanyoTexto=cell.getStringCellValue().length();
	          
	                 if(tamanyoTexto>55)
	                 {
	                 	row.setHeightInPoints((short)(row.getHeightInPoints()*((tamanyoTexto/55)+1)));
	                 }
	                cell.setCellStyle(estiloFila(i,excel));
		 	         cell = row.createCell((short)4);
		 	         cell.setCellStyle(estiloFila(i,excel));
		 	         cell = row.createCell((short)5);
		 	         cell.setCellStyle(estiloFila(i,excel));
		 	        cell = row.createCell((short)6);
		 	         cell.setCellStyle(estiloFila(i,excel));
		 	        cell = row.createCell((short)7);
		 	         cell.setCellStyle(estiloFila(i,excel));
	                 
	                 i++;
        		}
        	}
        	
        }
        
        int finImpugnante=i;
        
       
         region = new Region(iImpug,(short)2,finImpugnante,(short)8);
         HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
         HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
         HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
         HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
         HSSFRegionUtil.setBorderRight((short)1, region, sheet, wb);
         HSSFRegionUtil.setRightBorderColor((short)0, region, sheet, wb);
         HSSFRegionUtil.setBorderLeft((short)1, region, sheet, wb);
         HSSFRegionUtil.setLeftBorderColor((short)0, region, sheet, wb);
        
        
        
        
        int inicioVoces=i+2;
        i=i+1;
        short altofila1;
        short altofila2;
       if(impugnacion.getCodsVoces()!=null && !impugnacion.getCodsVoces().equals("|") && impugnacion.getCodsVoces().length()>0)
        {
        	altofila1=0;
        	altofila2=0;
        	  row = sheet.createRow((short)i+1); 
              cell = row.createCell((short)3); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.vocesLaudo",idioma));
              
              sheet.addMergedRegion(new Region(i+2,Short.parseShort("3"),i+2,Short.parseShort("4")));//NOPMD
              row = sheet.createRow((short)i+2); 
              cell = row.createCell((short)3); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.tipoVoz",idioma));
              tamanyoTexto=cell.getStringCellValue().length();
              
              if(tamanyoTexto>33)
              {
              	altofila1=(short)(row.getHeightInPoints()*((tamanyoTexto/32)+1));
              }
              cell = row.createCell((short)4); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              
              
              sheet.addMergedRegion(new Region(i+2,Short.parseShort("5"),i+2,Short.parseShort("6")));//NOPMD
             
              cell = row.createCell((short)5); 
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.voz",idioma));
              tamanyoTexto=cell.getStringCellValue().length();
              
              if(tamanyoTexto>33)
              {
              	altofila2=(short)(row.getHeightInPoints()*((tamanyoTexto/32)+1));
              }
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              cell = row.createCell((short)6); 
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              if(altofila1>altofila2 && altofila1>0)
              {
            	  row.setHeightInPoints(altofila1);
              }else if(altofila2>0)
              {
            	  row.setHeightInPoints(altofila2);
              }

              
              cell = row.createCell((short)7); 
              cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma));
              cell.setCellStyle(W83bClsEstilosExcel.estiloNegritaSubrayado(wb));
              
                          
             
              
              i=i+3;
              String[] dese=impugnacion.getVoces_dese().split("\\?");
              String[] desc=impugnacion.getVoces_desc().split("\\?");
             
              String[] datos;
              if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
              	datos=dese;
              else
             	 datos=desc;
              
              
        	for(int y=0;y<datos.length;y++)
        	{
        		
               
        		if(!datos[y].equals("|@|"))
        		{
        			String[] cods=datos[y].split("@")[1].split("\\|");
        			String[] descripciones=datos[y].split("@")[0].split("\\|");
               	 
        			sheet.addMergedRegion(new Region(i,Short.parseShort("3"),i,Short.parseShort("4")));//NOPMD
        			row = sheet.createRow((short)i); 
                    cell = row.createCell((short)3); 
               	 	cell.setCellValue( cods[0]+" - "+W83bUtilidadesExcel.mayusculasCampoExcel(descripciones[0]));
                    cell.setCellStyle(estiloFila(i, excel));
                    cell = row.createCell((short)4); 
               	 	cell.setCellStyle(estiloFila(i, excel));

               	 	sheet.addMergedRegion(new Region(i,Short.parseShort("5"),i,Short.parseShort("6")));//NOPMD
               	 	row = sheet.createRow((short)i); 
                    cell = row.createCell((short)5); 
                    cell.setCellValue( cods[1]+" - "+W83bUtilidadesExcel.mayusculasCampoExcel(descripciones[1]));
                    cell.setCellStyle(estiloFila(i, excel));
                    cell = row.createCell((short)6); 
                    cell.setCellStyle(estiloFila(i, excel));
                    
                    row = sheet.createRow((short)i); 
                    cell = row.createCell((short)7);
                    if(cods[2].equals("1"))
                    {
                    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma));
                    }else if(cods[2].equals("0")){
                    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma));
                    }else{
                   	 	cell.setCellValue(W83bClsConstantes.VACIO);
                     
                    }
                    cell.setCellStyle(estiloFila(i, excel));
        		}
                 
                i++;
        	}
        	 int finVoces=i;
        	 
        	 region = new Region(inicioVoces,(short)2,finVoces,(short)8);
        	 HSSFRegionUtil.setBorderBottom((short)1, region, sheet, wb);
             HSSFRegionUtil.setBottomBorderColor((short)0, region, sheet, wb);
             HSSFRegionUtil.setBorderTop((short)1, region, sheet, wb);
             HSSFRegionUtil.setTopBorderColor((short)0, region, sheet, wb);
             HSSFRegionUtil.setBorderRight((short)1, region, sheet, wb);
             HSSFRegionUtil.setRightBorderColor((short)0, region, sheet, wb);
             HSSFRegionUtil.setBorderLeft((short)1, region, sheet, wb);
             HSSFRegionUtil.setLeftBorderColor((short)0, region, sheet, wb); 
        }
    
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=fichaImpugnacion.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		HSSFCellStyle estilo;
		if(nFila%2==0){
			estilo=excel.styleTextoPar10;
			
		}else{
			estilo=excel.styleTextoImpar10;		
			
		}
	
		estilo.setVerticalAlignment(HSSFCellStyle.VERTICAL_JUSTIFY);
		return estilo;
		
	}

}

